/*
 ******************************************************************************
 File:     main.c
 Info:     Generated by Atollic TrueSTUDIO(R) 7.0.1   2017-01-12

 The MIT License (MIT)
 Copyright (c) 2009-2016 Atollic AB

 Permission is hereby granted, free of charge, to any person obtaining a copy
 of this software and associated documentation files (the "Software"), to deal
 in the Software without restriction, including without limitation the rights
 to use, copy, modify, merge, publish, distribute, sublicense, and/or sell
 copies of the Software, and to permit persons to whom the Software is
 furnished to do so, subject to the following conditions:

 The above copyright notice and this permission notice shall be included in all
 copies or substantial portions of the Software.

 THE SOFTWARE IS PROVIDED "AS IS", WITHOUT WARRANTY OF ANY KIND, EXPRESS OR
 IMPLIED, INCLUDING BUT NOT LIMITED TO THE WARRANTIES OF MERCHANTABILITY,
 FITNESS FOR A PARTICULAR PURPOSE AND NONINFRINGEMENT. IN NO EVENT SHALL THE
 AUTHORS OR COPYRIGHT HOLDERS BE LIABLE FOR ANY CLAIM, DAMAGES OR OTHER
 LIABILITY, WHETHER IN AN ACTION OF CONTRACT, TORT OR OTHERWISE, ARISING FROM,
 OUT OF OR IN CONNECTION WITH THE SOFTWARE OR THE USE OR OTHER DEALINGS IN THE
 SOFTWARE.
 ******************************************************************************
 */

/* Includes */
#include "stm32l4xx.h"
#include "gpio.h"

/* Private macro */
/* Private variables */
/* Private function prototypes */
/* Private functions */

/**
 **===========================================================================
 **
 **  Abstract: main program
 **
 **===========================================================================
 */

using namespace halpp;

template<typename TDev, unsigned short PIN, typename TTraits = TGpioTraits<TDev> > class TLed {
	TLed();
	explicit TLed(const TLed&);
public:
	static void Init() {
		TTraits::SetPinMode(PIN, GpioModeOutput);
		TTraits::SetPinOutputType(PIN, GpioPushPull);
		TTraits::SetPinPullMode(PIN, GpioNoPull);
	}

	static void Set() {
		TTraits::WritePin(PIN, 1);
	}

	static void Reset() {
		TTraits::WritePin(PIN, 0);
	}

	static void Toogle() {
		TTraits::TooglePin(PIN);
	}
};

template<typename TDev, typename TTraits = TGpioTraits<TDev> > class TLedInst {
	const unsigned short m_ledNo;

	explicit TLedInst(const TLedInst&);
public:
	TLedInst(unsigned short led) : m_ledNo(led) {
	}
	void Init() const {
		TTraits::SetPinMode(m_ledNo, GpioModeOutput);
		TTraits::SetPinOutputType(m_ledNo, GpioPushPull);
		TTraits::SetPinPullMode(m_ledNo, GpioNoPull);
	}

	void Set() const {
		TTraits::WritePin(m_ledNo, 1);
	}

	void Reset() const {
		TTraits::WritePin(m_ledNo, 0);
	}

	void Toogle() const {
		TTraits::TooglePin(m_ledNo);
	}
};

class AHB2Bus {
public:
	static void Enable(unsigned int flag) {
		RCC->AHB2ENR |= flag;
	}
};

class APB1Bus {
public:
	static void Enable(unsigned int flag) {
		RCC->APB1ENR1 |= flag;
	}
};

class APB1Bus2 {
	static void Enable(uint32_t flag) {
		RCC->APB1ENR2 |= flag;
	}
};

template<typename TBus, unsigned short ENF> class TDevice {
public:
	static void Enable() {
		TBus::Enable(ENF);
	}
};

class Hardware {
public:
	class GpioA: public TDevice<AHB2Bus, RCC_AHB2ENR_GPIOAEN> {
	public:
		static GPIO_TypeDef& instance() {
			return *GPIOA;
		}
	};

	class Tim3: public TDevice<AHB1Bus, RCC_APB1ENR1_TIM3EN> {
	public:
		static TIM_TypeDef& instance() {
			return *TIM3;
		}
	};

	static const TLedInst<GpioA> greenLed;
	static const TLedInst<GpioA> led2;

};

const TLedInst<Hardware::GpioA> Hardware::greenLed(5);
const TLedInst<Hardware::GpioA> Hardware::led2(5);

int main(void) {

	/**
	 *  IMPORTANT NOTE!
	 *  The symbol VECT_TAB_SRAM needs to be defined when building the project
	 *  if code has been located to RAM and interrupts are used.
	 *  Otherwise the interrupt table located in flash will be used.
	 *  See also the <system_*.c> file and how the SystemInit() function updates
	 *  SCB->VTOR register.
	 *  E.g.  SCB->VTOR = 0x20000000;
	 */

	/* TODO - Add your application code here */

	Hardware::GpioA::Enable();
	Hardware::greenLed.Init();
	Hardware::led2.Init();

	/* Infinite loop */
	while (1) {
		Hardware::greenLed.Toogle();
		Hardware::led2.Toogle();

		for (int i = 0; i < 1000000; i++) {
		}
	}
}
