﻿using System;
using System.Collections.Generic;
using System.Linq;
using System.Text;
using System.Threading.Tasks;
using Apache.NMS;
using Apache.NMS.Util;
using System.IO;
using LiteDB;
using System.Xml.Linq;

namespace Logger
{
    class Program
    {

        public class History
        {
            public Guid MsgID { get; set; }
            public string Name { get; set; }
            public DateTime Time { get; set; }
            public string Text { get; set; }
        }



        static IMessageConsumer m_consumer;
        public static void Main(string[] args)
        {
            Console.WriteLine("Starting up Logger.");
            Console.Beep(450, 1500);
            //ConsoleKeyInfo cki;



            IConnection m_connection;
            //ISession m_sendSession;
            ISession m_receiveSession;
            //IDestination m_sendDestination;
            IDestination m_receiveDestination;
            IConnectionFactory factory = new NMSConnectionFactory("tcp://31.173.88.87:61616");
            m_connection = factory.CreateConnection();

            m_connection.Start();
            //m_sendSession = m_connection.CreateSession(AcknowledgementMode.AutoAcknowledge);
            m_receiveSession = m_connection.CreateSession(AcknowledgementMode.AutoAcknowledge);
            //m_sendDestination = SessionUtil.GetTopic(m_sendSession, "Topic");
            m_receiveDestination = SessionUtil.GetQueue(m_receiveSession, "QueueLogger");
            m_consumer = m_receiveSession.CreateConsumer(m_receiveDestination);


            Receiver();
            Console.ReadKey();
        }

        static void Receiver()
        {
            var d = new MessageListener(OnMessage);
            m_consumer.Listener += d;
        }
        static void OnMessage(IMessage msg)
        {
            if (msg is ITextMessage)
            {
                ITextMessage txtMsg = msg as ITextMessage;
                String body = txtMsg.Text;
                using (var db = new LiteDatabase(@"C:\MyData2.db"))
                using (var reader = new StringReader(body))
                {
                    var xmldoc = XDocument.Load(reader);
                    var msgs = from el in xmldoc.Elements()
                               select new History
                               {
                                   MsgID = Guid.NewGuid(),
                                   Name = el.Element("Nickname") != null && !String.IsNullOrEmpty(el.Element("Nickname").Value) ? el.Element("Nickname").Value : "<anon>",
                                   Time = DateTime.Parse(el.Element("TimeStamp").Value),
                                   Text = el.Element("Message").Value
                               };
                    var messages = db.GetCollection<History>("Messages");
                    foreach (var item in msgs)
                    {

                        messages.Insert(item);
                        //m_chatwindow.Text += String.Format("{0} {1}:{2}\n", item.Name, item.Timestamp, item.Text);
                        //m_chatwindow.Text += body.ToString();

                    }
                }





                Console.WriteLine(body.ToString());
                {
                    string writePath = @"C:\history.txt";
                    using (StreamWriter sw = new StreamWriter(writePath, true))
                    {
                        sw.WriteLine(body.ToString());
                        sw.Close();
                    }


                }
            }

        }
    }
}