﻿using System;
using System.Collections.Generic;
using System.Linq;
using System.Text;
using System.Threading.Tasks;
using System.Windows;
using System.Windows.Controls;
using System.Windows.Data;
using System.Windows.Documents;
using System.Windows.Input;
using System.Windows.Media;
using System.Windows.Media.Imaging;
using System.Windows.Navigation;
using System.Windows.Shapes;
using Apache.NMS;
using Apache.NMS.Util;
using System.Xml;
using System.Xml.Linq;
using System.IO;
using System.Text;


namespace PalladaChat
{
    /// <summary>
    /// Логика взаимодействия для MainWindow.xaml
    /// </summary>
    public partial class MainWindow : Window
    {
        private readonly IConnection m_connection;

        private ISession m_sendSession;
        private ISession m_receiveSession;
        private IDestination m_sendDestination;
        private IDestination m_receiveDestination;
        private IMessageConsumer m_consumer;
        
        
        
        public MainWindow()
        {
            InitializeComponent();
            IConnectionFactory factory = new NMSConnectionFactory("tcp://31.173.88.87:61616");
            m_connection = factory.CreateConnection();
        }


        private void Receiver()
        {
            var d = new MessageListener(OnMessage);
            m_consumer.Listener += d;
        }

        void OnMessage(IMessage msg)
        {
            if (msg is ITextMessage)
            {
                ITextMessage txtMsg = msg as ITextMessage;
                String body = txtMsg.Text;
                using (var reader = new StringReader(body))
                {
                    var xmldoc = XDocument.Load(reader);

                    //var nick = xmldoc.Root.Elements().Where(el => el.Name == "Nickname").Select(el => el.Value).FirstOrDefault();
                    //var nick2 = (from el in xmldoc.Root.Elements()
                    //             where el.Name == "Nickname"
                    //             select el.Value).FirstOrDefault();

                    var msgs = from el in xmldoc.Elements()
                               select new
                               {
                                   
                                   Name = el.Element("Nickname") != null && !String.IsNullOrEmpty(el.Element("Nickname").Value) ? el.Element("Nickname").Value : "<anon>",
                                   Timestamp = DateTime.Parse(el.Element("TimeStamp").Value),
                                   Text = el.Element("Message").Value
                               };

                    foreach (var item in msgs)
                    {
                        m_chatwindow.Dispatcher.Invoke(new Action(delegate
                        {
                            m_chatwindow.Text += String.Format("{0} {1}:{2}\n", item.Name, item.Timestamp, item.Text);
                            //m_chatwindow.Text += body.ToString();

                        }));
                    }
                        }
            }

        }

        private void Button_Click_1(object sender, RoutedEventArgs e)
        {
            string m_richmsg = m_nickname.Text.ToString() + " " + DateTime.Now + " : " + m_msg.Text.ToString();
            
            //m_chatwindow.Text += m_richmsg.ToString() + "\n";
            if (m_richmsg != null)
            {
               
                XDocument doc = new XDocument(new XElement("TextMessage",
                                            new XElement("Nickname", m_nickname.Text.ToString()),
                                            new XElement("TimeStamp", DateTime.Now),
                                            new XElement("Message", m_msg.Text.ToString())));
                

                    using (m_sendDestination)
                    using (var producer = m_sendSession.CreateProducer(m_sendDestination))
                    {
                        var message = m_sendSession.CreateTextMessage(doc.ToString());
                        producer.Send(message);
                    }

            }
            m_msg.Text = null;
       
        }

        private void Loading(object sender, RoutedEventArgs e)
        {
            m_connection.Start();
            m_sendSession = m_connection.CreateSession(AcknowledgementMode.AutoAcknowledge);
            m_receiveSession = m_connection.CreateSession(AcknowledgementMode.AutoAcknowledge);
            m_sendDestination = SessionUtil.GetTopic(m_sendSession, "Topic");
            m_receiveDestination = SessionUtil.GetTopic(m_receiveSession, "Topic");
            m_consumer = m_receiveSession.CreateConsumer(m_receiveDestination);
            Receiver();
        }

        private void m_msg_KeyUp(object sender, KeyEventArgs e)
        {
            if (e.Key != System.Windows.Input.Key.Enter) return;
            e.Handled = true;
            Button_Click_1(sender, e);
        }

        private void Window_Closing_1(object sender, System.ComponentModel.CancelEventArgs e)
        {
            m_sendDestination.Dispose();
            m_receiveDestination.Dispose();
            m_consumer.Dispose();
            m_sendSession.Dispose();
            m_connection.Stop();
        }      
    }
}
