<?xml version="1.0" encoding="UTF-8"?>
<xsl:stylesheet
    version="1.0"
    xmlns:xsl="http://www.w3.org/1999/XSL/Transform"
>
    <xsl:import href="default.xsl"/>
    <xsl:include href="briefsections.xsl"/>
    <xsl:template name="compounddefType">
	    <h1>namespace <xsl:apply-templates select="compoundname" mode="compounddefType"/></h1>
	    <xsl:if test="innernamespace">
		    <div class="dox-ref-section">
		    	<h2>Namespaces</h2>
		    	<ul>
		    		<xsl:apply-templates select="innernamespace" mode="compounddefType" />
		    	</ul>
		    </div>
	    </xsl:if>
	    <xsl:if test="innerclass">
	    	<div class="dox-ref-section">
		    	<h2>Classes</h2>
		    	<ul>
		    		<xsl:apply-templates select="innerclass" mode="compounddefType" />
		    	</ul>
		    </div>
	    </xsl:if>
	    <xsl:if test="sectiondef">
		    <div class="dox-ref-section">
		    	<h2>Members</h2>
				<xsl:apply-templates select="sectiondef" mode="compounddefType" />
			</div>
		</xsl:if>
    
    </xsl:template>
    <xsl:template match="innernamespace" mode="compounddefType">
    	<li><xsl:apply-imports/></li>
    </xsl:template>
    
    <xsl:template match="innerclass" mode="compounddefType">
    	<li><xsl:apply-imports/></li>
    </xsl:template>
</xsl:stylesheet>