<?xml version='1.0' encoding='utf-8'?>
<xsl:stylesheet
    version="1.0"
    xmlns:xsl="http://www.w3.org/1999/XSL/Transform"
>
	<xsl:template match="memberdef" mode="sectiondefType">
		<div class="memberdef">
			<div class="memberdefName">
				<xsl:call-template name="memberdefName" />
			</div>
			<div class="memberdefDescription">
				<xsl:call-template name="memberdefDescription" />
			</div>
		</div>
	</xsl:template>

	<xsl:template name="memberdefName">
		<span class="textPre">
			<xsl:if test="@virt = 'virtual'">
				<xsl:text>virtual </xsl:text>
			</xsl:if>
			<xsl:if test="@kind = 'enum'">
				<xsl:text>enum </xsl:text>
			</xsl:if>
			<xsl:if test="type">
				<xsl:apply-templates select="type" mode="memberdefType" />
				<xsl:text disable-output-escaping="yes">&amp;nbsp;</xsl:text>
			</xsl:if>
			<xsl:call-template name="link">
				<xsl:with-param name="refid" select="@id" />
				<xsl:with-param name="kind" select="'member'" />
				<xsl:with-param name="external" />
				<xsl:with-param name="text">
					<xsl:apply-templates select="name" mode="memberdefType" />
				</xsl:with-param>
			</xsl:call-template>
			<xsl:if test="argsstring">
				<xsl:text disable-output-escaping="yes">&amp;nbsp;</xsl:text>
				<xsl:apply-templates select="argsstring" mode="memberdefType"/>
			</xsl:if>
			<xsl:if test="initializer">
				<xsl:text> </xsl:text>
				<xsl:apply-templates select="initializer" mode="memberdefType" />
			</xsl:if>
			<xsl:if test="@kind = 'property'">
				<xsl:text>{ </xsl:text>
				<xsl:if test="@gettable = 'yes'"><xsl:text>get; </xsl:text></xsl:if>
				<xsl:if test="@settable = 'yes'"><xsl:text>set; </xsl:text></xsl:if>
				<xsl:text>}</xsl:text>
			</xsl:if>
		</span>
	</xsl:template>

	<xsl:template name="memberdefDescription">
		<xsl:apply-templates select="briefdescription"
			mode="memberdefType" />
	</xsl:template>
</xsl:stylesheet>