define([ 'dojo/on', 'dojo/dom-geometry', 'dojo/dom-style' ], function(on, g,
		css) {

	return function(sticker, options) {
		var dh, pos;

		var pos = g.position(sticker,true);

		var origLeft = css.get(sticker,'left');
		var left = pos.x + 'px';

		if (options && options.along) {
			var along = g.position(options.along,true);
			dh = along.y + along.h - pos.h - pos.y;
		} else {
			dh = window.scrollMaxY - pos.h - pos.y;
		}

		var fixed = false;
		
		var stfn = function() {
			if(!options || !options.along)
				dh = window.scrollMaxY - pos.h - pos.y;

			if (window.scrollY >= pos.y && window.scrollY <= pos.y + dh) {
				if (!fixed) {
					css.set(sticker, { top : 0, left: left, position : 'fixed' });
					fixed = true;
				}
			} else {
				if (fixed) {
					fixed = false;
					
					css.set(sticker, { position : 'relative', left: origLeft });

					if (window.scrollY < pos.y) {
						css.set(sticker, { top : 'auto' });
					} else {
						css.set(sticker, { top : dh + 'px' });
					}
				}
			}
		};
		
		stfn();

		on(window, 'scroll', stfn );
	};
});