<?xml version="1.0" encoding="UTF-8"?>
<xsl:stylesheet
    version="1.0"
    xmlns:xsl="http://www.w3.org/1999/XSL/Transform"
>
    <xsl:import href="default.xsl"/>
    <xsl:template name="compounddefType">
		<h1>
			<xsl:apply-templates select="title|compoundname"
				mode="compounddefType" />
		</h1>
		<div class="briefdescription">
			<xsl:apply-templates select="briefdescription"
				mode="compounddefType" />
		</div>
		<div class="dox-source-code">
			<span class="keyword">
				<xsl:value-of select="concat(@prot,' ')"/>
				<xsl:if test="@abstract"><xsl:text>abstract </xsl:text></xsl:if>
				<xsl:if test="@sealed"><xsl:text>sealed </xsl:text></xsl:if>
				<xsl:value-of select="concat(@kind,' ')"/>
			</span>
			<xsl:call-template name="short-type-name">
				<xsl:with-param name="typename" select="compoundname"/>
			</xsl:call-template>
			<xsl:if test="basecompoundref">
				<xsl:text> : </xsl:text>
				<xsl:for-each select="basecompoundref">
					<xsl:call-template name="compoundRefType"/>
					<xsl:if test="not(last() = position())">
						<xsl:text>, </xsl:text>
					</xsl:if>
				</xsl:for-each>
			</xsl:if>
		</div>
		<div class="detaileddescription">
			<xsl:apply-templates select="detaileddescription"
				mode="compounddefType" />
		</div>

		<div class="innerCompounds">
			
			<xsl:apply-templates select="innerclass | innernamespace"
				mode="compounddefType" />
		</div>

		<div class="members">
			<xsl:apply-templates select="sectiondef" mode="compounddefType" />
		</div>

		<xsl:if test="derivedcompoundref">
			<div class="sectiondef">
				<h3>Derived</h3>
				<ul class="derivedcompoundref-list">
				<xsl:apply-templates select="derivedcompoundref"
					mode="compounddefType" />
				</ul>
			</div>
		</xsl:if>
	</xsl:template>
	<xsl:template match="derivedcompoundref" mode="compounddefType">
		<li><xsl:apply-imports/></li>
	</xsl:template>
	
	<xsl:template match="memberdef" mode="sectiondefType">
		<div class="memberdef">
			<div class="memberdefName">
				<xsl:call-template name="memberdefName" />
			</div>
			<div class="memberdefDescription">
				<xsl:call-template name="memberdefDescription" />
			</div>
		</div>
	</xsl:template>

	<xsl:template name="memberdefName">
		<span class="textPre">
			<xsl:if test="type">
				<xsl:apply-templates select="type" mode="memberdefType" />
				<xsl:text disable-output-escaping="yes">&amp;nbsp;</xsl:text>
			</xsl:if>
			<xsl:call-template name="link">
				<xsl:with-param name="refid" select="@id" />
				<xsl:with-param name="kind" select="'member'" />
				<xsl:with-param name="external" />
				<xsl:with-param name="text">
					<xsl:apply-templates select="name" mode="memberdefType"/>
				</xsl:with-param>
			</xsl:call-template>
			<xsl:text disable-output-escaping="yes">&amp;nbsp;</xsl:text>
			<xsl:value-of select="argsstring/text()" />
		</span>
	</xsl:template>

	<xsl:template name="memberdefDescription">
		<xsl:apply-templates select="briefdescription"
			mode="memberdefType" />
	</xsl:template>
</xsl:stylesheet>