#!/usr/bin/perl -w
use strict;
use config;

use IMPL::require {
	HG => 'Benzin::SCC::Mercurial'
};

`rm -r /tmp/ImplabNet` if -d '/tmp/ImplabNet';

my $repo = HG->Clone(
	'https://hg.implab.org/private/Pallada.PoiskAvia',
	'/tmp/ImplabNet',
	['-r' => 10],
	\%config::hgSettings
);

foreach my $info (@{$repo->Income() || []}) {
	print "$info->{number} : $info->{hash}\n";
}

$repo->Pull('-u', '-r' => 20);

print "done\n";