package Implab::Web::Resources::Root;
use strict;

use IMPL::declare {
	require => {
		LibraryResource => '-Benzin::Web::Resources::Doxygen::Library',
		UserResource => '-Benzin::Web::Resources::UserResource',
		Sec => 'IMPL::Security'
	},
	base => [
		'IMPL::Web::Application::Resource' => '@_'
	]
};

sub children {
	my $this = shift;
	return {
		library => {
			class => LibraryResource,
			connection => $this->application->connections->{doxLibrary}
		},
		user => {
			model => sub {
				Sec->principal;
			},
			role => 'user',
			class => UserResource,
			components => [qw(login logout passwd edit)]
		}
	};	
}

1;