<?xml version="1.0" encoding="UTF-8"?>
<xsl:stylesheet
    version="1.0"
    xmlns:xsl="http://www.w3.org/1999/XSL/Transform"
>
    <xsl:import href="default.xsl"/>
    <xsl:param name="memberId"/>
    <xsl:template name="compounddefType">
		<xsl:apply-templates select="//memberdef[@id = $memberId]"/>
	</xsl:template>
	
	<xsl:template match="memberdef[@kind = 'enum']">
		<xsl:call-template name="memberdefType"/>
		<table class="pretty-table">
			<tr>
				<th>Name</th>
				<th>Description</th>
			</tr>
			<xsl:for-each select="enumvalue">
				<tr>
					<td>
						<xsl:value-of select="concat(name, ' ', initializer)"/>
					</td>
					<td>
						<xsl:apply-templates select="briefdescription" mode="compounddefType"/>
						<xsl:apply-templates select="detaileddescription" mode="compounddefType"/>
					</td>
				</tr>
			</xsl:for-each>
		</table>
	</xsl:template>
	
	<xsl:template match="memberdef">
		<xsl:call-template name="memberdefType"/>
	</xsl:template>
	
	<xsl:template name="memberdefType">
		<h1><xsl:value-of select="name"/></h1>
		<div class="briefdescription">
			<xsl:apply-templates select="briefdescription"
				mode="memberdefType" />
		</div>
		<div class="dox-source-code">
			<xsl:value-of select="concat(@prot,' ')"/>
			<xsl:if test="@virt = 'virtual'">
				<xsl:text>virtual </xsl:text>
			</xsl:if>
			<xsl:if test="@kind = 'enum'">
				<xsl:text>enum </xsl:text>
			</xsl:if>
			<xsl:if test="type">
				<xsl:apply-templates select="type" mode="memberdefType" />
				<xsl:text disable-output-escaping="yes">&amp;nbsp;</xsl:text>
			</xsl:if>
			<span class="memberName">
				<xsl:value-of select="name"/>
			</span>
			<xsl:if test="argsstring">
				<xsl:text disable-output-escaping="yes">&amp;nbsp;</xsl:text>
				<xsl:apply-templates select="argsstring" mode="memberdefType"/>
			</xsl:if>
			<xsl:if test="initializer">
				<xsl:text> </xsl:text>
				<xsl:apply-templates select="initializer" mode="memberdefType" />
			</xsl:if>
			<xsl:if test="@kind = 'property'">
				<xsl:text>{ </xsl:text>
				<xsl:if test="@gettable = 'yes'"><xsl:text>get; </xsl:text></xsl:if>
				<xsl:if test="@settable = 'yes'"><xsl:text>set; </xsl:text></xsl:if>
				<xsl:text>}</xsl:text>
			</xsl:if>
		</div>
		<xsl:if test="detaileddescription">
			<div class="detaileddescription">
				<xsl:apply-templates select="detaileddescription" mode="memberdefType"/>
			</div>
		</xsl:if>
	</xsl:template>

</xsl:stylesheet>