define([ 'dojo/on', 'dojo/dom-geometry', 'dojo/dom-style' ], function(on, g,
		css) {

	/**
	 * @param [Dom|string]
	 *            stiker element to become a sticker
	 */
	return function(sticker, options) {
		var dh, pos;

		var pos = g.position(sticker, true);
		var clientWidth = g.position(document.body).w;
		var stickRight = options ? options.stick == 'right' : false;

		var origPos = css.get(sticker, stickRight ? 'right' : 'left');

		var fixPos = (stickRight ? clientWidth - pos.w - pos.x : pos.x) + 'px';

		var dhcalc = function() {
			if (options && options.along) {
				var along = g.position(options.along, true);
				dh = along.y + along.h - pos.h - pos.y;
				if (options.alongContent)
					// respect bottom padding and border
					dh -= g.getPadExtents(options.along).t
							+ g.getBorderExtents(options.along).t;
			} else {
				dh = window.scrollMaxY - pos.h - pos.y;
			}
		};

		var fixed = false;

		var stfn = function() {
			if (!options || !options.along)
				dh = window.scrollMaxY - pos.h - pos.y;

			if (window.scrollY >= pos.y && window.scrollY <= pos.y + dh) {
				if (!fixed) {
					if (stickRight)
						css.set(sticker, {
							top : 0,
							right : fixPos,
							position : 'fixed'
						});
					else
						css.set(sticker, {
							top : 0,
							left : fixPos,
							position : 'fixed'
						});
					fixed = true;
				}
			} else {
				if (fixed) {
					fixed = false;

					if (stickRight)
						css.set(sticker, {
							position : 'relative',
							right : origPos
						});
					else
						css.set(sticker, {
							position : 'relative',
							left : origPos
						});

					if (window.scrollY < pos.y) {
						css.set(sticker, {
							top : 'auto'
						});
					} else {
						css.set(sticker, {
							top : dh + 'px'
						});
					}
				}
			}
		};

		dhcalc();
		stfn();

		on(window, 'scroll', stfn);
		on(window, 'resize', dhcalc);
	};
});