<?xml version="1.0" encoding="UTF-8"?>
<xsl:stylesheet version="1.0"
	xmlns:xsl="http://www.w3.org/1999/XSL/Transform">
	<xsl:import href="base.xsl" />
	<xsl:param name="compounds" />
	<xsl:param name="members" />
	<xsl:variable name="labels" select="document('labels.xml')"/>
	
	<xsl:key name="param-key" use="concat(generate-id(parent::node()),declname/text())" match="memberdef/param[declname]"/>

	<xsl:output method="html" encoding="utf-8" indent="yes"
		omit-xml-declaration="yes" />

	<!-- The main template -->
	<xsl:template name="compounddefType">
		<h1>
			<xsl:apply-templates select="title|compoundname"
				mode="compounddefType" />
		</h1>
		<div class="briefdescription">
			<xsl:apply-templates select="briefdescription"
				mode="compounddefType" />
		</div>
		<div class="basecompoundref">
			<pre>
				<xsl:apply-templates select="basecompoundref"
					mode="compounddefType" />
			</pre>
		</div>
		<div class="detaileddescription">
			<xsl:apply-templates select="detaileddescription"
				mode="compounddefType" />
		</div>

		<div class="innerCompounds">
			<xsl:apply-templates select="innerclass | innernamespace"
				mode="compounddefType" />
		</div>

		<div class="members">
			<xsl:apply-templates select="sectiondef" mode="compounddefType" />
		</div>

		<xsl:if test="derivedcompoundref">
			<div class="derivedcompoundref">
				<h2>Derived</h2>
				<xsl:apply-templates select="derivedcompoundref"
					mode="compounddefType" />
			</div>
		</xsl:if>
	</xsl:template>

	<xsl:template match="compoundname" mode="compounddefType">
		<xsl:call-template name="full-type-name">
			<xsl:with-param name="typename" select="text()" />
		</xsl:call-template>
	</xsl:template>

	<!-- handle references -->
	<xsl:template name="compoundRefType">
		<xsl:choose>
			<xsl:when test="@refid">
				<xsl:call-template name="link">
					<xsl:with-param name="class" select="'doxCompoundRef'"/>
					<xsl:with-param name="refid" select="@refid" />
	   				<xsl:with-param name="kind" select="'compound'" />
	   				<xsl:with-param name="external" />
	   				<xsl:with-param name="text" select="text()" />
				</xsl:call-template>
			</xsl:when>
			<xsl:otherwise>
				<span class="doxCompoundRef">
					<xsl:value-of select="text()" />
				</span>
			</xsl:otherwise>
		</xsl:choose>
	</xsl:template>

	<xsl:template name="refTextType">
		<xsl:element name="a">
			<xsl:attribute name="href">
    			<xsl:call-template name="ref">
    				<xsl:with-param name="refid" select="@refid" />
    				<xsl:with-param name="kind" select="@kindref" />
    				<xsl:with-param name="external" select="@external" />
    			</xsl:call-template>
    		</xsl:attribute>
			<xsl:value-of select="text()" />
		</xsl:element>
	</xsl:template>

	<xsl:template match="innerclass" mode="compounddefType">
		<xsl:call-template name="link">
			<xsl:with-param name="refid" select="@refid" />
			<xsl:with-param name="kind" select="'compound'" />
			<xsl:with-param name="external" />
			<xsl:with-param name="text" >
				<xsl:call-template name="short-type-name">
					<xsl:with-param name="typename" select="text()" />
				</xsl:call-template> 
			</xsl:with-param>
		</xsl:call-template>
	</xsl:template>

	<xsl:template match="innernamespace" mode="compounddefType">
		<xsl:element name="a">
			<xsl:attribute name="href">
            	<xsl:call-template name="ref">
    				<xsl:with-param name="refid" select="@refid" />
    				<xsl:with-param name="kind" select="'compound'" />
    				<xsl:with-param name="external" />
    			</xsl:call-template>
            </xsl:attribute>
			<xsl:call-template name="short-type-name">
				<xsl:with-param name="typename" select="text()" />
			</xsl:call-template>
		</xsl:element>
	</xsl:template>

	<xsl:template name="docRefTextType">
		<xsl:element name="a">
			<xsl:attribute name="href">
    			<xsl:call-template name="ref">
    				<xsl:with-param name="refid" select="@refid" />
    				<xsl:with-param name="kind" select="@kindref" />
    				<xsl:with-param name="external" select="@external" />
    			</xsl:call-template>
    		</xsl:attribute>
			<xsl:apply-templates mode="docRefTextType" />
		</xsl:element>
	</xsl:template>

	<!-- paragraph -->
	<xsl:template name="docParaType">
		<p class="para">
			<xsl:apply-templates mode="docParaType" />
		</p>
	</xsl:template>

	<!-- inline markup -->
	<xsl:template name="docMarkupType">
		<xsl:choose>
			<xsl:when test="name() = 'computeroutput'">
				<span class="docTextPre">
					<xsl:apply-templates mode="docMarkupType" />
				</span>
			</xsl:when>
			<xsl:otherwise>
				<xsl:apply-templates mode="docMarkupType" />
			</xsl:otherwise>
		</xsl:choose>
	</xsl:template>

	<!-- paramlist -->
	<xsl:template name="docParamListType">
		<div class="parameterlist">
			<h4>
				<xsl:call-template name="translate-paramlist">
					<xsl:with-param name="name" select="@kind"/>
				</xsl:call-template>
			</h4>
			<xsl:choose>
				<xsl:when test="@kind = 'param'">
					<xsl:call-template name="docParamListType-param"/>
				</xsl:when>
				<xsl:otherwise>
					<table class="pretty-table">
						<tr>
							<th>
								Parameter
							</th>
							<th>
								Description
							</th>
						</tr>
						<xsl:apply-templates mode="docParamListType" />
					</table>
				</xsl:otherwise>
			</xsl:choose>
		</div>
	</xsl:template>

	<xsl:template match="parameteritem" mode="docParamListType">
		<tr>
			<td>
				<xsl:apply-templates select="parameternamelist" />
			</td>
			<td>
				<xsl:apply-templates select="parameterdescription" />
			</td>
		</tr>
	</xsl:template>
	
	<xsl:template name="docParamListType-param">
		<table class="pretty-table">
			<tr>
				<th>
					Type
				</th>
				<th>
					Parameter
				</th>
				<th>
					Description
				</th>
			</tr>
			<xsl:apply-templates mode="docParamListType-param" />
		</table>
	</xsl:template>
	
	<xsl:template match="parameteritem" mode="docParamListType-param">
		<tr>
			<td>
				<xsl:apply-templates select="key('param-key', concat(generate-id(ancestor::memberdef),parameternamelist/parametername/text()))/type" mode="paramType" />
			</td>
			<td>
				<xsl:apply-templates select="parameternamelist" mode="docParamListItem"/>
			</td>
			<td>
				<xsl:apply-templates select="parameterdescription" mode="docParamListItem"/>
			</td>
		</tr>
	</xsl:template>

	<!-- section -->
	<xsl:template name="sectiondefType">
		<div class="sectiondef">
			<h3>
				<xsl:call-template name="section-label">
					<xsl:with-param name="name" select="@kind"/>
				</xsl:call-template>
			</h3>
			<div>
				<xsl:apply-templates mode="sectiondefType" />
			</div>
		</div>
	</xsl:template>
	
	<xsl:template name="docSimpleSectType">
		<div class="simplesection">
			<h3>
				<xsl:call-template name="translate-simplesection">
					<xsl:with-param name="name" select="@kind"/>
				</xsl:call-template>
			</h3>
			<div>
				<xsl:apply-templates mode="docSimpleSectType" />
			</div>
		</div>
	</xsl:template>
	
	<xsl:template match="simplesectsep" mode="docSimpleSectType"><hr class="simplesectsep" /></xsl:template>
	
	<!-- SOURCE CODE FORMATTING -->
	
	<xsl:template name="listingType">
		<xsl:apply-templates mode="listingType"/>
	</xsl:template>
	<xsl:template name="codelineType">
		<div>
			<xsl:apply-templates mode="codelineType"/>
		</div>
	</xsl:template>
	<xsl:template match="sp" mode="highlightType">
		<xsl:text disable-output-escaping="yes">&amp;nbsp;</xsl:text>
	</xsl:template>
	<xsl:template match="highlight" mode="codelineType">
		<span class="{@class}"><xsl:call-template name="highlightType"/></span>
	</xsl:template>

	<!-- TOOLS -->
	<xsl:template name="link">
		<xsl:param name="refid" />
		<xsl:param name="kind" />
		<xsl:param name="external" select="''" />
		<xsl:param name="text" select="'[ link here ]'" />
		<xsl:param name="class" select="''"/>
		<xsl:element name="a">
			<xsl:attribute name="href">
				<xsl:call-template name="ref">
					<xsl:with-param name="refid" select="$refid" />
					<xsl:with-param name="kind" select="$kind" />
					<xsl:with-param name="external" select="$external" />
				</xsl:call-template>
			</xsl:attribute>
			<xsl:if test="$class">
				<xsl:attribute name="class"><xsl:value-of select="$class"/></xsl:attribute>
			</xsl:if>
			<xsl:choose>
				<xsl:when test="*">
					<xsl:copy-of select="$text"/>
				</xsl:when>
				<xsl:otherwise>
					<xsl:value-of select="$text"/>
				</xsl:otherwise>
			</xsl:choose>
		</xsl:element>
		
	</xsl:template>
	<xsl:template name="ref">
		<xsl:param name="refid" />
		<xsl:param name="kind" />
		<xsl:param name="external" select="''" />
		<xsl:choose>
			<xsl:when test="$kind = 'member'">
				<xsl:value-of select="concat($members,'/',$refid)" />
			</xsl:when>
			<xsl:when test="$kind = 'compound'">
				<xsl:value-of select="concat($compounds,'/',$refid)" />
			</xsl:when>
			<xsl:otherwise></xsl:otherwise>
		</xsl:choose>
	</xsl:template>

	<xsl:template name="string-replace-all">
		<xsl:param name="text" />
		<xsl:param name="replace" />
		<xsl:param name="with" />
		<xsl:choose>
			<xsl:when test="contains($text, $replace)">
				<xsl:value-of select="substring-before($text,$replace)" />
				<xsl:value-of select="$with" />
				<xsl:call-template name="string-replace-all">
					<xsl:with-param name="text"
						select="substring-after($text,$replace)" />
					<xsl:with-param name="replace" select="$replace" />
					<xsl:with-param name="with" select="$with" />
				</xsl:call-template>
			</xsl:when>
			<xsl:otherwise>
				<xsl:value-of select="$text" />
			</xsl:otherwise>
		</xsl:choose>
	</xsl:template>

	<xsl:template name="full-type-name">
		<xsl:param name="typename" />
		<xsl:call-template name="string-replace-all">
			<xsl:with-param name="text" select="$typename" />
			<xsl:with-param name="replace" select="'::'" />
			<xsl:with-param name="with" select="'.'" />
		</xsl:call-template>
	</xsl:template>

	<xsl:template name="short-type-name">
		<xsl:param name="typename" />
		<xsl:choose>
			<xsl:when test="contains($typename,'::')">
				<xsl:call-template name="short-type-name">
					<xsl:with-param name="typename"
						select="substring-after($typename,'::')" />
				</xsl:call-template>
			</xsl:when>
			<xsl:otherwise>
				<xsl:value-of select="$typename" />
			</xsl:otherwise>
		</xsl:choose>
	</xsl:template>
	
	<xsl:template name="section-label">
		<xsl:param name="name"/>
		<xsl:variable name="label" select="$labels/labels/sections/label[@name = $name]"/>
		<xsl:choose>
			<xsl:when test="$label"><xsl:value-of select="$label"/></xsl:when>
			<xsl:otherwise><xsl:value-of select="$name" /></xsl:otherwise>
		</xsl:choose>
	</xsl:template>
	
	<xsl:template name="translate-section">
		<xsl:param name="name"/>
		<xsl:variable name="label" select="$labels/labels/sections/label[@name = $name]"/>
		<xsl:choose>
			<xsl:when test="$label"><xsl:value-of select="$label"/></xsl:when>
			<xsl:otherwise><xsl:value-of select="$name" /></xsl:otherwise>
		</xsl:choose>
	</xsl:template>
	
	<xsl:template name="translate-simplesection">
		<xsl:param name="name"/>
		<xsl:variable name="label" select="$labels/labels/simplesections/label[@name = $name]"/>
		<xsl:choose>
			<xsl:when test="$label"><xsl:value-of select="$label"/></xsl:when>
			<xsl:otherwise><xsl:value-of select="$name" /></xsl:otherwise>
		</xsl:choose>
	</xsl:template>
	
	<xsl:template name="translate-paramlist">
		<xsl:param name="name"/>
		<xsl:variable name="label" select="$labels/labels/paramlists/label[@name = $name]"/>
		<xsl:choose>
			<xsl:when test="$label"><xsl:value-of select="$label"/></xsl:when>
			<xsl:otherwise><xsl:value-of select="$name" /></xsl:otherwise>
		</xsl:choose>
	</xsl:template>

</xsl:stylesheet>