#!/usr/bin/perl
use strict;
use lib '.';
use config;

use IMPL::Config();
use IMPL::require {
	TTSelector => 'IMPL::Web::View::TTFsSelector',
	Dumper => 'Data::Dumper'
};


my $selector = TTSelector->new(
	isContainer => 1,
	ext => '.tt',
	path => IMPL::Config->AppDir('view','site')
);

my $match = $selector->MatchPath(
	[
	    { name => 'library'},
		{ name => 'index', class => 'Some::Collection' },
		{ name => 'compounds' },
		{ name => 'asd--df-sd-f--ds-we', class => 'Some::Compound' }
	]
);

print Dumper->Dump([$match]);