<?xml version="1.0" encoding="UTF-8"?>
<xsl:stylesheet
    version="1.0"
    xmlns:xsl="http://www.w3.org/1999/XSL/Transform"
>
    <xsl:import href="default.xsl"/>
    <xsl:include href="briefsections.xsl"/>
    <xsl:template name="compounddefType">
		<h1>
			<xsl:apply-templates select="title|compoundname"
				mode="compounddefType" />
		</h1>
		<div class="briefdescription">
			<xsl:apply-templates select="briefdescription"
				mode="compounddefType" />
		</div>
		<div class="dox-source-code">
			<span class="keyword">
				<xsl:value-of select="concat(@prot,' ')"/>
				<xsl:if test="@abstract"><xsl:text>abstract </xsl:text></xsl:if>
				<xsl:if test="@sealed"><xsl:text>sealed </xsl:text></xsl:if>
				<xsl:value-of select="concat(@kind,' ')"/>
			</span>
			<xsl:call-template name="short-type-name">
				<xsl:with-param name="typename" select="compoundname"/>
			</xsl:call-template>
			<xsl:if test="basecompoundref">
				<xsl:text> : </xsl:text>
				<xsl:for-each select="basecompoundref">
					<xsl:call-template name="compoundRefType"/>
					<xsl:if test="not(last() = position())">
						<xsl:text>, </xsl:text>
					</xsl:if>
				</xsl:for-each>
			</xsl:if>
		</div>
		<div class="detaileddescription">
			<xsl:apply-templates select="detaileddescription"
				mode="compounddefType" />
		</div>

		<xsl:if test="innerclass">
			<div class="sectiondef">
				<h3>Inner classes</h3>
				<ul>
				<xsl:apply-templates select="innerclass"
					mode="compounddefType" />
				</ul>
			</div>
		</xsl:if>

		<div class="members">
			<xsl:apply-templates select="sectiondef" mode="compounddefType" />
		</div>

		<xsl:if test="derivedcompoundref">
			<div class="sectiondef">
				<h3>Derived</h3>
				<ul class="derivedcompoundref-list">
				<xsl:apply-templates select="derivedcompoundref"
					mode="compounddefType" />
				</ul>
			</div>
		</xsl:if>
	</xsl:template>
	<xsl:template match="derivedcompoundref" mode="compounddefType">
		<li><xsl:apply-imports/></li>
	</xsl:template>
	<xsl:template match="innerclass" mode="compounddefType">
		<li><xsl:apply-imports/></li>
	</xsl:template>
</xsl:stylesheet>