use strict;
use warnings;

use File::Spec;
use Carp;

my @dirs;

BEGIN {
	$Carp::Verbose = 0; # set this to 1 to enable carp traces
    my $cwd = (File::Spec->splitpath($ENV{SCRIPT_FILENAME} || $0))[1];
    @dirs = File::Spec->splitdir($cwd);
    
    #go two dirs up
    pop @dirs unless pop @dirs; # remove empty dir in case of trailing /
    pop @dirs;
    
	push @INC, File::Spec->catdir(@dirs,'lib');
	
	package IMPL::Config;
	
	our $AppBase = File::Spec->catdir(@dirs);
	our $ConfigBase = File::Spec->catdir(@dirs,'config');
	
	package IMPL::Web::Application::ControllerUnit;
	
	our @schemaInc;
	
	push @schemaInc, File::Spec->catdir(@dirs,'schema');
	
	package main;
	
	my $bootstrap = File::Spec->catfile($ConfigBase, 'bootstrap.pm');
	if( -f $bootstrap ) {
	    do $bootstrap;
	    
	    ($! ? die($@,$!) : die($@) )if $@;
	    
	}

}

1;