#!/usr/bin/perl -w
use strict;
use config;

use IMPL::require {
	HG => 'Benzin::SCC::Mercurial'
};

`rm -r /tmp/ImplabNet` if -d '/tmp/ImplabNet';

my $repo = HG->Clone(
	'https://hg.implab.org/private/Pallada.PoiskAvia',
	'/tmp/ImplabNet',
	['-r' => 10],
	\%config::hgSettings
);

$repo->name('ImplabNet');
$repo->SaveConfig();

print "repo: ", $repo->hgrc->val('paths','default')," name: " ,$repo->name, "\n";

$repo->Pull('-u', '-r' => 20);

print "LISTING\n";
print "repo: ",$_->path, " " , $_->hgrc->val('paths','default','local'), "\n"
	foreach @{HG->ListRepos('/tmp')};


print "done\n";